<?php
ob_start();
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Toplam satışları çek
$sqlSatış = "SELECT SUM(toplam_tutar) as toplam_satis FROM cari_satislar";
$stmtSatış = $pdo->query($sqlSatış);
$toplamSatış = $stmtSatış->fetch()['toplam_satis'];

// Toplam tahsilatları çek
$sqlTahsilat = "SELECT SUM(tutar) as toplam_tahsilat FROM tahsilatlar";
$stmtTahsilat = $pdo->query($sqlTahsilat);
$toplamTahsilat = $stmtTahsilat->fetch()['toplam_tahsilat'];

// Toplam alışları çek
$sqlAlış = "SELECT SUM(toplam_tutar) as toplam_alis FROM cari_alislar";
$stmtAlış = $pdo->query($sqlAlış);
$toplamAlış = $stmtAlış->fetch()['toplam_alis'];

// Toplam ödemeleri çek
$sqlÖdeme = "SELECT SUM(tutar) as toplam_odeme FROM odemeler";
$stmtÖdeme = $pdo->query($sqlÖdeme);
$toplamÖdeme = $stmtÖdeme->fetch()['toplam_odeme'];

ob_end_flush();
?>




<style>
    
    .mobile-menu {
    margin-top: 20px;
    padding: 10px;
    background-color: #f8f9fa;
    border-radius: 8px;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
}

.accordion-button {
    background-color: #73a1d1;
    color: #fff;
    font-weight: bold;
}

.accordion-button:not(.collapsed) {
    color: #007bff;
    background-color: #e7f1ff;
}

.list-group-item {
    border: none;
    padding: 10px 15px;
}

.list-group-item a {
    color: #007bff;
    text-decoration: none;
}

.list-group-item a:hover {
    text-decoration: underline;
}

</style>
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <!-- Dashboard İçerikleri -->
                <div class="container-xxl flex-grow-1 container-p-y">
                    <div class="row">
                     <div class="col-lg-8 mb-4 order-0">
    <div class="card">
        <div class="d-flex align-items-end row">
            <div class="col-sm-7">
                <div class="card-body">
                    <h5 class="card-title text-primary">Yönetim paneline hoşgeldiniz 🎉</h5>
                    <p class="mb-4">
                        Bu <span class="fw-bold">panelden </span>cari hesaplarınızı kolayca takip edebilirsiniz.
                    </p>
                </div>
            </div>
            <div class="col-sm-5 text-center text-sm-left">
                <div class="card-body pb-0 px-0 px-md-4">
                    <img src="../assets/img/illustrations/man-with-laptop-light.png" height="140" alt="View Badge User" data-app-dark-img="illustrations/man-with-laptop-dark.png" data-app-light-img="illustrations/man-with-laptop-light.png"/>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Mobil Menü -->
<div class="mobile-menu d-block d-lg-none">
    <div class="accordion" id="accordionExample">
        
        <!-- Anasayfa -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingHome">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseHome" aria-expanded="true" aria-controls="collapseHome">
                    <i class="bx bx-home"></i> Anasayfa
                </button>
            </h2>
            <div id="collapseHome" class="accordion-collapse collapse show" aria-labelledby="headingHome" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <a href="admin.php" class="list-group-item">Anasayfa</a>
                </div>
            </div>
        </div>

        <!-- Müşteri İşlemleri -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingMusteri">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseMusteri" aria-expanded="false" aria-controls="collapseMusteri">
                    <i class="bx bx-user"></i> Müşteri İşlemleri
                </button>
            </h2>
            <div id="collapseMusteri" class="accordion-collapse collapse" aria-labelledby="headingMusteri" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <a href="musteri_ekle.php" class="list-group-item">Müşteri Ekle</a>
                    <a href="musteri_listesi.php" class="list-group-item">Müşteri Listesi</a>
                </div>
            </div>
        </div>

        <!-- Satış Cari İşlemleri -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingSatisCari">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSatisCari" aria-expanded="false" aria-controls="collapseSatisCari">
                    <i class="bx bx-cart"></i> Satış Cari İşlemleri
                </button>
            </h2>
            <div id="collapseSatisCari" class="accordion-collapse collapse" aria-labelledby="headingSatisCari" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <a href="cari_satis_ekle.php" class="list-group-item">Cari Satış Ekle</a>
                    <a href="tahsilat_ekle.php" class="list-group-item">Tahsilat Ekle</a>
                    <a href="cari_satis_listesi.php" class="list-group-item">Cari Satış Kayıt Listesi</a>
                    <a href="tahsilat_listesi.php" class="list-group-item">Tahsilat Kayıt Listesi</a>
                    <a href="cari_ekstre.php" class="list-group-item">Cari Ekstre</a>
                    <a href="musteri_genel_borc.php" class="list-group-item">Müşteri Genel Borç</a>
                </div>
            </div>
        </div>

        <!-- Firma İşlemleri -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingFirma">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFirma" aria-expanded="false" aria-controls="collapseFirma">
                    <i class="bx bx-building-house"></i> Firma İşlemleri
                </button>
            </h2>
            <div id="collapseFirma" class="accordion-collapse collapse" aria-labelledby="headingFirma" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <a href="firma_ekle.php" class="list-group-item">Firma Ekle</a>
                    <a href="firma_listesi.php" class="list-group-item">Firma Listesi</a>
                </div>
            </div>
        </div>

        <!-- Alış Firma İşlemleri -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingAlisFirma">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAlisFirma" aria-expanded="false" aria-controls="collapseAlisFirma">
                    <i class="bx bx-cart-alt"></i> Alış Firma İşlemleri
                </button>
            </h2>
            <div id="collapseAlisFirma" class="accordion-collapse collapse" aria-labelledby="headingAlisFirma" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <a href="cari_alis_ekle.php" class="list-group-item">Cari Alış Ekle</a>
                    <a href="odeme_ekle.php" class="list-group-item">Ödeme Ekle</a>
                    <a href="cari_alis_listesi.php" class="list-group-item">Cari Alış Kayıt Listesi</a>
                    <a href="odeme_listesi.php" class="list-group-item">Ödeme Kayıt Listesi</a>
                    <a href="firma_cari_ekstre.php" class="list-group-item">Firma Cari Ekstre</a>
                    <a href="firma_genel_borc.php" class="list-group-item">Firma Genel Borç</a>
                </div>
            </div>
        </div>

        <!-- Resmi Satışlar -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingResmiSatis">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseResmiSatis" aria-expanded="false" aria-controls="collapseResmiSatis">
                    <i class="bx bx-file"></i> Resmi Satışlar
                </button>
            </h2>
            <div id="collapseResmiSatis" class="accordion-collapse collapse" aria-labelledby="headingResmiSatis" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <a href="resmi_cari_satis_ekle.php" class="list-group-item">Resmi Cari Satış Ekle</a>
                    <a href="resmi_tahsilat_ekle.php" class="list-group-item">Resmi Tahsilat Ekle</a>
                    <a href="resmi_cari_satis_listesi.php" class="list-group-item">Resmi Cari Satış Listesi</a>
                    <a href="resmi_tahsilat_listesi.php" class="list-group-item">Resmi Tahsilat Kayıt Listesi</a>
                    <a href="resmi_cari_ekstre.php" class="list-group-item">Resmi Cari Ekstre</a>
                    <a href="resmi_musteri_genel_borc.php" class="list-group-item">Resmi Müşteri Genel Borç</a>
                </div>
            </div>
        </div>

        <!-- Çek İşlemleri -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingCek">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseCek" aria-expanded="false" aria-controls="collapseCek">
                    <i class="bx bx-credit-card"></i> Çek İşlemleri
                </button>
            </h2>
            <div id="collapseCek" class="accordion-collapse collapse" aria-labelledby="headingCek" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <a href="cek_ekle.php" class="list-group-item">Çek Ekle</a>
                    <a href="cek_listesi.php" class="list-group-item">Çek Listesi</a>
                </div>
            </div>
        </div>

        <!-- Personel İşlemleri -->
      <?php if (isset($_SESSION['role']) && $_SESSION['role'] == 'admin'): ?>
    <div class="accordion-item">
        <h2 class="accordion-header" id="headingPersonel">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePersonel" aria-expanded="false" aria-controls="collapsePersonel">
                <i class="bx bx-user-plus"></i> Personel İşlemleri
            </button>
        </h2>
        <div id="collapsePersonel" class="accordion-collapse collapse" aria-labelledby="headingPersonel" data-bs-parent="#accordionExample">
            <div class="accordion-body">
                <a href="register.php" class="list-group-item">Personel Ekle</a>
                <a href="kullanicilar.php" class="list-group-item">Personeller</a>
            </div>
        </div>
    </div>
<?php endif; ?>


        <!-- Çıkış -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingCikis">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseCikis" aria-expanded="false" aria-controls="collapseCikis">
                    <i class="bx bx-exit"></i> Çıkış
                </button>
            </h2>
            <div id="collapseCikis" class="accordion-collapse collapse" aria-labelledby="headingCikis" data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <a href="logout.php" class="list-group-item">Çıkış</a>
                </div>
            </div>
        </div>

    </div>
</div>


<!-- Mobil Menü Bitiş -->

                        
                        
                        
                        <div class="col-lg-4 col-md-4 order-1">
                            <div class="row">
                                 <div class="col-lg-6 col-md-12 col-6 mb-4">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-title d-flex align-items-start justify-content-between">
                                                <div class="avatar flex-shrink-0">
                                                    <img src="../assets/img/icons/unicons/wallet-info.png" alt="chart success" class="rounded"/>
                                                </div>
                                            </div>
                                            <span class="fw-semibold d-block mb-1">Toplam Satış</span>
                                            <h3 class="card-title mb-2"><?php echo number_format($toplamSatış, 2); ?> TL</h3>
                                        </div>
                                    </div>
                                </div>
                               <div class="col-lg-6 col-md-12 col-6 mb-4">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-title d-flex align-items-start justify-content-between">
                                                <div class="avatar flex-shrink-0">
                                                    <img src="../assets/img/icons/unicons/wallet-info.png" alt="Credit Card" class="rounded"/>
                                                </div>
                                            </div>
                                            <span>Toplam Tahsilat</span>
                                            <h3 class="card-title text-nowrap mb-1"><?php echo number_format($toplamTahsilat, 2); ?> TL</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Total Revenue -->
                             <div class="col-12 col-lg-8 order-2 order-md-3 order-lg-2 mb-4">
                                     <div class="card">
                                 <div class="row row-bordered g-0">
                                   
                                  
                                 </div>
                                </div>
                            </div>
                        <!--/ Total Revenue -->
                        <div class="col-12 col-md-8 col-lg-4 order-3 order-md-2">
                            <div class="row">
                                <div class="col-6 mb-4">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-title d-flex align-items-start justify-content-between">
                                                <div class="avatar flex-shrink-0">
                                                    <img src="../assets/img/icons/unicons/cc-primary.png" alt="Credit Card" class="rounded"/>
                                                </div>
                                         
                                            </div>
                                            <span class="d-block mb-1">Toplam Alış</span>
                                            <h3 class="card-title text-nowrap mb-2"><?php echo number_format($toplamAlış, 2); ?> TL</h3>
                                   
                                        </div>
                                    </div>
                                </div>
                                <div class="col-6 mb-4">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-title d-flex align-items-start justify-content-between">
                                                <div class="avatar flex-shrink-0">
                                                    <img src="../assets/img/icons/unicons/cc-primary.png" alt="Credit Card" class="rounded"/>
                                                </div>
                                         
                                            </div>
                                            <span class="fw-semibold d-block mb-1">Toplam Ödeme</span>
                                            <h3 class="card-title mb-2"><?php echo number_format($toplamÖdeme, 2); ?> TL</h3>
                                        
                                        </div>
                                    </div>
                                </div>
                           
                            </div>
                        </div>
                    </div>

                    <!-- Order Statistics -->
                    <div class="row">
                       
               
                    </div>
                </div>
                <!--/ Dashboard İçerikleri -->
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
