<?php
ob_start();
session_start();
require 'db.php';
include 'sidebar.php';
include 'header.php';

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// ID parametresini al ve kontrol et
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    // Kayıt bilgilerini al
    $sql = "SELECT * FROM cari_alislar WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id]);
    $kayit = $stmt->fetch();

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $firma_id = $_POST['firma_id'];
        $fatura_no = $_POST['fatura_no'];
        $urun_hizmet_adi = $_POST['urun_hizmet_adi'];
        $miktar = $_POST['miktar'];
        $fiyat = $_POST['fiyat'];
        $kdv_orani = $_POST['kdv_orani'];
        $tarih = $_POST['tarih'];
        $aciklama = $_POST['aciklama'];

        $ara_toplam = $miktar * $fiyat;
        $kdv_tutari = ($ara_toplam * $kdv_orani) / 100;
        $toplam_tutar = $ara_toplam + $kdv_tutari;

        // Kayıt güncelleme sorgusu
        $sql = "UPDATE cari_alislar SET firma_id = ?, fatura_no = ?, urun_hizmet_adi = ?, miktar = ?, fiyat = ?, kdv_orani = ?, toplam_tutar = ?, aciklama = ?, tarih = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);

        if ($stmt->execute([$firma_id, $fatura_no, $urun_hizmet_adi, $miktar, $fiyat, $kdv_orani, $toplam_tutar, $aciklama, $tarih, $id])) {
            $_SESSION['message'] = "Kayıt başarıyla güncellendi!";
            header("Location: cari_alis_listesi.php");
            exit;
        } else {
            $_SESSION['error'] = "Kayıt güncellenirken bir hata oluştu.";
        }
    }
} else {
    $_SESSION['error'] = "Geçersiz işlem.";
    header("Location: cari_alis_listesi.php");
    exit;
}

ob_end_flush();
?>

<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>

<div class="layout-container">

 <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
            </br>
</br></br>     <h4 class="mb-4">Cari Alış Düzenle</h4>
                <form action="cari_alis_duzenle.php?id=<?php echo $id; ?>" method="post" class="border p-4 shadow rounded">
                    <div class="mb-3">
                        <label for="firma_id" class="form-label">Firma ID:</label>
                        <input type="text" class="form-control" name="firma_id" value="<?php echo htmlspecialchars($kayit['firma_id']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="fatura_no" class="form-label">Fatura No:</label>
                        <input type="text" class="form-control" name="fatura_no" value="<?php echo htmlspecialchars($kayit['fatura_no']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="urun_hizmet_adi" class="form-label">Ürün/Hizmet Adı:</label>
                        <input type="text" class="form-control" name="urun_hizmet_adi" value="<?php echo htmlspecialchars($kayit['urun_hizmet_adi']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="miktar" class="form-label">Miktar:</label>
                        <input type="number" class="form-control" name="miktar" id="miktar" value="<?php echo htmlspecialchars($kayit['miktar']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="fiyat" class="form-label">Fiyat:</label>
                        <input type="number" class="form-control" name="fiyat" id="fiyat" value="<?php echo htmlspecialchars($kayit['fiyat']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="kdv_orani" class="form-label">KDV Oranı (%):</label>
                        <input type="number" class="form-control" name="kdv_orani" id="kdv_orani" value="<?php echo htmlspecialchars($kayit['kdv_orani']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="tarih" class="form-label">Tarih:</label>
                        <input type="date" class="form-control" name="tarih" value="<?php echo htmlspecialchars($kayit['tarih']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="toplam_tutar" class="form-label">Toplam Tutar:</label>
                        <input type="text" class="form-control" id="toplam_tutar" value="<?php echo htmlspecialchars($kayit['toplam_tutar']); ?> TL" disabled>
                    </div>
                    <div class="mb-3">
                        <label for="aciklama" class="form-label">Açıklama:</label>
                        <textarea class="form-control" name="aciklama"><?php echo htmlspecialchars($kayit['aciklama']); ?></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </form>

                <!-- Toplam Tutarın Otomatik Hesaplanması için JavaScript -->
                <script>
                    document.getElementById('miktar').addEventListener('input', hesaplaToplamTutar);
                    document.getElementById('fiyat').addEventListener('input', hesaplaToplamTutar);
                    document.getElementById('kdv_orani').addEventListener('input', hesaplaToplamTutar);

                    function hesaplaToplamTutar() {
                        var miktar = parseFloat(document.getElementById('miktar').value) || 0;
                        var fiyat = parseFloat(document.getElementById('fiyat').value) || 0;
                        var kdv_orani = parseFloat(document.getElementById('kdv_orani').value) || 0;

                        var ara_toplam = miktar * fiyat;
                        var kdv_tutari = (ara_toplam * kdv_orani) / 100;
                        var toplam_tutar = ara_toplam + kdv_tutari;

                        document.getElementById('toplam_tutar').value = toplam_tutar.toFixed(2) + ' TL';
                    }

                    // Sayfa yüklendiğinde mevcut değerleri kullanarak toplam tutarı hesapla
                    document.addEventListener('DOMContentLoaded', function () {
                        hesaplaToplamTutar();
                    });
                </script>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
