<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

// Sadece admin ve user rolleri erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Cari alış kayıtlarını veritabanından çek
$sql = "SELECT cari_alislar.*, firmalar.firma_adi, users.username 
        FROM cari_alislar 
        LEFT JOIN firmalar ON cari_alislar.firma_id = firmalar.id
        LEFT JOIN users ON cari_alislar.created_by = users.id";
$stmt = $pdo->query($sql);
$kayitlar = $stmt->fetchAll();

// Başarı ve hata mesajlarını gösterme
if (isset($_SESSION['message'])) {
    echo "<div class='alert alert-success'>" . $_SESSION['message'] . "</div>";
    unset($_SESSION['message']);
}
if (isset($_SESSION['error'])) {
    echo "<div class='alert alert-danger'>" . $_SESSION['error'] . "</div>";
    unset($_SESSION['error']);
}

ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır
?>
<style>
    .mobile-home-button {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        padding: 10px;
        background-color: #f8f9fa;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        z-index: 1000;
        text-align: center;
    }

    .mobile-home-button .btn {
        width: 90%;
        margin: 0 auto;
    }
</style> 

<div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>
<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                <h4 class="mb-4">Cari Alış Listesi</h4>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Firma Adı</th>
                            <th>Fatura No</th>
                            <th>Ürün/Hizmet Adı</th>
                            <th>Miktar</th>
                            <th>Fiyat</th>
                            <th>KDV Oranı</th>
                            <th>KDV Tutarı</th>
                            <th>Toplam Tutar</th>
                            <th>Açıklama</th>
                            <th>Tarih</th>
                            <th>Ekleyen Kullanıcı</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($kayitlar as $kayit): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($kayit['id']); ?></td>
                                <td><?php echo htmlspecialchars($kayit['firma_adi']); ?></td>
                                <td><?php echo htmlspecialchars($kayit['fatura_no']); ?></td>
                                <td><?php echo htmlspecialchars($kayit['urun_hizmet_adi']); ?></td>
                                <td><?php echo htmlspecialchars($kayit['miktar']); ?></td>
                                <td><?php echo number_format($kayit['fiyat'], 2, ',', '.') . ' TL'; ?></td>
                                <td><?php echo htmlspecialchars($kayit['kdv_orani']) . '%'; ?></td>
                                <td><?php echo number_format($kayit['kdv_tutari'], 2, ',', '.') . ' TL'; ?></td>
                                <td><?php echo number_format($kayit['toplam_tutar'], 2, ',', '.') . ' TL'; ?></td>
                                <td><?php echo htmlspecialchars($kayit['aciklama']); ?></td>
                                <td><?php echo htmlspecialchars($kayit['tarih']); ?></td>
                                <td><?php echo isset($kayit['username']) ? htmlspecialchars($kayit['username']) : 'Bilinmiyor'; ?></td>
                                <td>
                                    <a href="cari_alis_duzenle.php?id=<?php echo $kayit['id']; ?>" class="btn btn-primary btn-sm">Düzenle</a>
                                    <a href="cari_alis_sil.php?id=<?php echo $kayit['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?')">Sil</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
