<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Gelen ID'yi kontrol et
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $satis_id = $_GET['id'];

    // Cari satış kaydını getir
    $sql = "SELECT * FROM cari_satislar WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$satis_id]);
    $satis = $stmt->fetch();

    if (!$satis) {
        $_SESSION['error'] = "Cari satış kaydı bulunamadı.";
        header("Location: cari_satis_listesi.php");
        exit;
    }
} else {
    $_SESSION['error'] = "Geçersiz ID.";
    header("Location: cari_satis_listesi.php");
    exit;
}

// Güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $musteri_id = $_POST['musteri_id'];
    $tarih = $_POST['tarih'];
    $fatura_no = $_POST['fatura_no'];
    $urun_adi = $_POST['urun_adi'];
    $miktar = $_POST['miktar'];
    $fiyat = $_POST['fiyat'];
    $kdv_orani = $_POST['kdv_orani'];
    $aciklama = $_POST['aciklama'];

    // Toplam tutarı hesapla (miktar * fiyat + kdv)
    $kdv_tutari = ($fiyat * $miktar) * ($kdv_orani / 100);
    $toplam_tutar = ($fiyat * $miktar) + $kdv_tutari;

    // Güncelleme işlemi için SQL sorgusu
    $sql = "UPDATE cari_satislar SET musteri_id = ?, tarih = ?, fatura_no = ?, urun_adi = ?, miktar = ?, fiyat = ?, kdv_orani = ?, kdv_tutari = ?, toplam_tutar = ?, aciklama = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);

    if ($stmt->execute([$musteri_id, $tarih, $fatura_no, $urun_adi, $miktar, $fiyat, $kdv_orani, $kdv_tutari, $toplam_tutar, $aciklama, $satis_id])) {
        $_SESSION['message'] = "Cari satış başarıyla güncellendi.";
        header("Location: cari_satis_listesi.php");
        exit;
    } else {
        $_SESSION['error'] = "Cari satış güncellenirken bir hata oluştu.";
    }
}

// Müşteri listesini veritabanından çek
$musteri_sql = "SELECT id, ad_soyad FROM musteriler";
$musteri_stmt = $pdo->query($musteri_sql);
$musteriler = $musteri_stmt->fetchAll();
ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır
?>

<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>

<div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>
<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                  </br>
</br></br>     <h4 class="mb-4">Cari Satış Düzenle</h4>
                <form action="" method="post" class="border p-4 shadow rounded">
                    <div class="mb-3">
                        <label for="musteri_id" class="form-label">Müşteri:</label>
                        <select name="musteri_id" id="musteri_id" class="form-control" required>
                            <?php foreach ($musteriler as $musteri): ?>
                                <option value="<?php echo $musteri['id']; ?>" <?php echo ($satis['musteri_id'] == $musteri['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($musteri['ad_soyad']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="tarih" class="form-label">Tarih:</label>
                        <input type="date" class="form-control" name="tarih" id="tarih" value="<?php echo htmlspecialchars($satis['tarih']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="fatura_no" class="form-label">Fatura No:</label>
                        <input type="text" class="form-control" name="fatura_no" id="fatura_no" value="<?php echo htmlspecialchars($satis['fatura_no']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="urun_adi" class="form-label">Ürün Adı:</label>
                        <input type="text" class="form-control" name="urun_adi" id="urun_adi" value="<?php echo htmlspecialchars($satis['urun_adi']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="miktar" class="form-label">Miktar:</label>
                        <input type="number" class="form-control" name="miktar" id="miktar" value="<?php echo htmlspecialchars($satis['miktar']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="fiyat" class="form-label">Fiyat:</label>
                        <input type="number" step="0.01" class="form-control" name="fiyat" id="fiyat" value="<?php echo htmlspecialchars($satis['fiyat']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="kdv_orani" class="form-label">KDV Oranı (%):</label>
                        <input type="number" step="0.01" class="form-control" name="kdv_orani" id="kdv_orani" value="<?php echo htmlspecialchars($satis['kdv_orani']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="toplam_tutar" class="form-label">Toplam Tutar:</label>
                        <input type="text" class="form-control" id="toplam_tutar" value="<?php echo htmlspecialchars($satis['toplam_tutar']); ?> TL" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="aciklama" class="form-label">Açıklama:</label>
                        <textarea class="form-control" name="aciklama" id="aciklama"><?php echo htmlspecialchars($satis['aciklama']); ?></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const miktarInput = document.getElementById('miktar');
    const fiyatInput = document.getElementById('fiyat');
    const kdvInput = document.getElementById('kdv_orani');
    const toplamTutarInput = document.getElementById('toplam_tutar');

    function hesaplaToplamTutar() {
        const miktar = parseFloat(miktarInput.value) || 0;
        const fiyat = parseFloat(fiyatInput.value) || 0;
        const kdvOrani = parseFloat(kdvInput.value) || 0;

        const araTutar = miktar * fiyat;
        const kdvTutari = araTutar * (kdvOrani / 100);
        const toplamTutar = araTutar + kdvTutari;

        toplamTutarInput.value = toplamTutar.toFixed(2) + ' TL'; // Toplam tutarı iki ondalık basamakla göster
    }

    // Miktar, fiyat veya KDV oranı değiştiğinde toplam tutarı hesapla
    miktarInput.addEventListener('input', hesaplaToplamTutar);
    fiyatInput.addEventListener('input', hesaplaToplamTutar);
    kdvInput.addEventListener('input', hesaplaToplamTutar);

    // Sayfa yüklendiğinde mevcut değerleri kullanarak toplam tutarı hesapla
    hesaplaToplamTutar();
});
</script>

<?php include 'footer.php'; ?>
