<?php
ob_start(); // Tamponlama başlatılıyor

error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Cari satış ekleme işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $musteri_id = $_POST['musteri_id'];
    $tarih = $_POST['tarih'];
    $fatura_no = $_POST['fatura_no'];
    $urun_adi = $_POST['urun_adi'];
    $miktar = $_POST['miktar'];
    $fiyat = str_replace('.', '', $_POST['fiyat']); // Binlik ayraçları kaldır
    $fiyat = str_replace(',', '.', $fiyat); // Ondalık ayıracı dönüştür
    $kdv_orani = $_POST['kdv_orani'];
    $aciklama = $_POST['aciklama'];

    // Toplam tutarı hesapla (miktar * fiyat + kdv)
    $kdv_tutari = ($fiyat * $miktar) * ($kdv_orani / 100);
    $toplam_tutar = ($fiyat * $miktar) + $kdv_tutari;

    // Toplam tutarı formatla
    $formatted_toplam_tutar = number_format($toplam_tutar, 2, ',', '.');

    // Oturum açmış kullanıcının ID'sini al
    $created_by = $_SESSION['user_id'];

    // Veritabanına kaydet
    $sql = "INSERT INTO cari_satislar (musteri_id, tarih, fatura_no, urun_adi, miktar, fiyat, kdv_orani, kdv_tutari, toplam_tutar, aciklama, created_by) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute([$musteri_id, $tarih, $fatura_no, $urun_adi, $miktar, $fiyat, $kdv_orani, $kdv_tutari, $toplam_tutar, $aciklama, $created_by])) {
        $_SESSION['message'] = "Cari satış başarıyla eklendi! Toplam Tutar: " . $formatted_toplam_tutar;
    } else {
        $_SESSION['error'] = "Cari satış eklenirken bir hata oluştu.";
    }

    header("Location: cari_satis_ekle.php");
    exit;
}

// Müşteri listesini veritabanından çek
$musteri_sql = "SELECT id, ad_soyad FROM musteriler";
$musteri_stmt = $pdo->query($musteri_sql);
$musteriler = $musteri_stmt->fetchAll();
ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır

?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cari Satış Ekle</title>
    <!-- jQuery kütüphanesi -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
<div class="layout-wrapper layout-content-navbar">
  
    <div class="mobile-home-button d-block d-lg-none">
        <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
    </div>
    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    <h4 class="fw-bold py-3 mb-4">Cari Satış Ekle</h4>

                    <!-- Uyarı Mesajları -->
                    <?php if (isset($_SESSION['message'])): ?>
                        <div class="alert alert-success">
                            <?php echo $_SESSION['message']; ?>
                        </div>
                        <?php unset($_SESSION['message']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger">
                            <?php echo $_SESSION['error']; ?>
                        </div>
                        <?php unset($_SESSION['error']); ?>
                    <?php endif; ?>

                    <!-- Cari Satış Ekleme Formu -->
                    <div class="card">
                        <div class="card-body">
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="musteri_id" class="form-label">Müşteri Seç</label>
                                    <select name="musteri_id" class="form-select" id="musteri_id" required>
                                        <?php foreach ($musteriler as $musteri): ?>
                                            <option value="<?php echo $musteri['id']; ?>"><?php echo htmlspecialchars($musteri['ad_soyad']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="tarih" class="form-label">Tarih</label>
                                    <input type="date" name="tarih" class="form-control" id="tarih" required>
                                </div>
                                <div class="mb-3">
                                    <label for="fatura_no" class="form-label">Fatura No</label>
                                    <input type="text" name="fatura_no" class="form-control" id="fatura_no" required>
                                </div>
                                <div class="mb-3">
                                    <label for="urun_adi" class="form-label">Ürün Adı</label>
                                    <input type="text" name="urun_adi" class="form-control" id="urun_adi" required>
                                </div>
                                <div class="mb-3">
                                    <label for="miktar" class="form-label">Miktar</label>
                                <input type="number" name="miktar" class="form-control" id="miktar" step="0.01" required>

                                </div>
                                <div class="mb-3">
                                    <label for="fiyat" class="form-label">Fiyat</label>
                                    <input type="text" name="fiyat" class="form-control" id="fiyat" required>
                                </div>
                                <div class="mb-3">
                                    <label for="kdv_orani" class="form-label">KDV Oranı (%)</label>
                                    <input type="number" name="kdv_orani" class="form-control" id="kdv_orani" step="0.01" required>
                                </div>
                                <div class="mb-3">
                                    <label for="toplam_tutar" class="form-label">Toplam Tutar</label>
                                    <input type="text" name="toplam_tutar" class="form-control" id="toplam_tutar" readonly>
                                </div>
                                <div class="mb-3">
                                    <label for="aciklama" class="form-label">Açıklama</label>
                                    <textarea name="aciklama" class="form-control" id="aciklama"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary">Cari Satış Ekle</button>
                            </form>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tutar Alanlarını Formatlama ve Toplam Tutar Hesaplama -->
<script>
$(document).ready(function() {
    function formatNumber(num) {
        return num.toLocaleString('tr-TR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }

    function hesaplaToplamTutar() {
        var miktar = parseFloat($('#miktar').val()) || 0;
        var fiyat = parseFloat($('#fiyat').val().replace(/\./g, '').replace(',', '.')) || 0;
        var kdvOrani = parseFloat($('#kdv_orani').val()) || 0;

        var araTutar = miktar * fiyat;
        var kdvTutari = (araTutar * kdvOrani) / 100;
        var toplamTutar = araTutar + kdvTutari;

        $('#toplam_tutar').val(formatNumber(toplamTutar) + ' TL');
    }

    $('#miktar, #fiyat, #kdv_orani').on('input', hesaplaToplamTutar);

    $('#fiyat').on('input', function() {
        let value = $(this).val().replace(/[^0-9]/g, '');
        value = value.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        $(this).val(value);
    });
});
</script>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
