<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

// Yalnızca yönetici bu sayfaya erişebilir
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

// Kullanıcı bilgilerini getir
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = $_GET['id'];
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$id]);
    $user = $stmt->fetch();

    if (!$user) {
        exit('Kullanıcı bulunamadı.');
    }
} else {
    exit('Geçersiz ID.');
}

// Form gönderildiğinde güncelleme yap
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'] ?? $user['username'];
    $email = $_POST['email'] ?? $user['email'];
    $role = $_POST['role'] ?? $user['role'];
    $password = $_POST['password'];

    // Şifre alanı doldurulmuşsa, şifreyi güncelle
    if (!empty($password)) {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    } else {
        $hashed_password = $user['password'];
    }

    $stmt = $pdo->prepare("UPDATE users SET username = ?, email = ?, role = ?, password = ? WHERE id = ?");
    $stmt->execute([$username, $email, $role, $hashed_password, $id]);

    // Güncelleme başarılı ise bir mesaj sakla ve yönlendirme yap
    $_SESSION['success'] = "Kullanıcı başarıyla güncellendi.";
    header("Location: edit_user.php?id=" . $id);
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kullanıcı Düzenle</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="../assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="../assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="../assets/css/demo.css" />
    <link rel="stylesheet" href="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
</head>
<body>

<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Sidebar içeriği buraya dahil edilmeli -->

        <div class="layout-page">
            <!-- Üst menü içeriği buraya dahil edilmeli -->

            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    <h4 class="fw-bold py-3 mb-4">Kullanıcı Düzenle</h4>

                    <!-- Başarı mesajını görüntüleme -->
                    <?php if (isset($_SESSION['success'])): ?>
                        <div class="alert alert-success">
                            <?php echo $_SESSION['success']; ?>
                        </div>
                        <?php unset($_SESSION['success']); // Mesajı görüntüledikten sonra temizle ?>
                    <?php endif; ?>

                    <div class="card">
                        <div class="card-body">
                            <form action="" method="post">
                                <div class="mb-3">
                                    <label for="username" class="form-label">Kullanıcı Adı:</label>
                                    <input type="text" class="form-control" name="username" id="username" value="<?php echo htmlspecialchars($user['username']); ?>" required>
                                </div>

                                <div class="mb-3">
                                    <label for="email" class="form-label">E-posta:</label>
                                    <input type="email" class="form-control" name="email" id="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>
                                </div>

                                <div class="mb-3">
                                    <label for="password" class="form-label">Yeni Şifre (boş bırakılırsa değişmez):</label>
                                    <input type="password" class="form-control" name="password" id="password">
                                </div>

                                <div class="mb-3">
                                    <label for="role" class="form-label">Rol:</label>
                                    <select class="form-select" name="role" id="role">
                                        <option value="user" <?php echo $user['role'] == 'user' ? 'selected' : ''; ?>>Kullanıcı</option>
                                        <option value="admin" <?php echo $user['role'] == 'admin' ? 'selected' : ''; ?>>Yönetici</option>
                                    </select>
                                </div>

                                <button type="submit" class="btn btn-primary">Güncelle</button>
                            </form>
                        </div>
                    </div>

                    <a href="admin.php" class="btn btn-secondary mt-3">Geri Dön</a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JavaScript -->
<script src="../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
