<?php
require_once('tcpdf/tcpdf.php');
require 'db.php';

// Tüm müşteriler için genel borç durumu
$sql = "
SELECT 
    m.id,
    m.ad_soyad,
    COALESCE(SUM(cs.toplam_tutar), 0) AS toplam_satis,
    COALESCE((SELECT SUM(t.tutar) FROM tahsilatlar t WHERE t.musteri_id = m.id), 0) AS toplam_tahsilat,
    COALESCE(SUM(cs.toplam_tutar), 0) - COALESCE((SELECT SUM(t.tutar) FROM tahsilatlar t WHERE t.musteri_id = m.id), 0) AS bakiye
FROM 
    musteriler m
LEFT JOIN 
    cari_satislar cs ON m.id = cs.musteri_id
GROUP BY 
    m.id, m.ad_soyad
";

$stmt = $pdo->query($sql);
$musteriler = $stmt->fetchAll();

// Toplamlar için değişkenler
$toplam_satis = 0;
$toplam_tahsilat = 0;
$toplam_bakiye = 0;

foreach ($musteriler as $musteri) {
    $toplam_satis += $musteri['toplam_satis'];
    $toplam_tahsilat += $musteri['toplam_tahsilat'];
    $toplam_bakiye += $musteri['bakiye'];
}

// TCPDF nesnesini oluştur
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// PDF meta verilerini ayarlama
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Net Araç Takip Sistemleri');
$pdf->SetTitle('Müşteri Genel Borç Durumu');
$pdf->SetSubject('Genel Borç Durumu');
$pdf->SetKeywords('TCPDF, PDF, Genel Borç, Rapor');

// Üstbilgi ve altbilgi ayarları
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Yazı tipini ayarlama
$pdf->SetFont('dejavusans', '', 10);

// Yeni sayfa ekleme
$pdf->AddPage();

// PDF içeriğini oluşturma
$html = '<h1>Müşteri Genel Borç Durumu</h1>';

$html .= '<table border="1" cellpadding="4">
            <thead>
                <tr>
                    <th>Müşteri Adı</th>
                    <th>Toplam Satış</th>
                    <th>Toplam Tahsilat</th>
                    <th>Bakiye</th>
                </tr>
            </thead>
            <tbody>';

foreach ($musteriler as $musteri) {
    $html .= '<tr>
                <td>' . htmlspecialchars($musteri['ad_soyad']) . '</td>
                <td>' . number_format($musteri['toplam_satis'], 2) . ' TL</td>
                <td>' . number_format($musteri['toplam_tahsilat'], 2) . ' TL</td>
                <td>' . number_format($musteri['bakiye'], 2) . ' TL</td>
              </tr>';
}

$html .= '</tbody></table>';

// Toplamları ekleme
$html .= '<h3 style="text-align: right; margin-top: 20px;">Toplam Satış: ' . number_format($toplam_satis, 2) . ' TL</h3>';
$html .= '<h3 style="text-align: right;">Toplam Tahsilat: ' . number_format($toplam_tahsilat, 2) . ' TL</h3>';
$html .= '<h2 style="text-align: right; font-weight: bold;">Kalan Bakiye: ' . number_format($toplam_bakiye, 2) . ' TL</h2>';

// HTML içeriği PDF'e ekleme
$pdf->writeHTML($html, true, false, true, false, '');

// PDF'i tarayıcıda gösterme
$pdf->Output('musteri_genel_borc.pdf', 'I');
?>
