<?php
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

$musteri_id = null;
$resmi_cari_satislar = [];
$resmi_tahsilatlar = [];
$total_resmi_satis = 0;
$total_resmi_tahsilat = 0;

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['musteri_id'])) {
    $musteri_id = $_POST['musteri_id'];

    // Seçilen müşteriye ait resmi cari satışları getirme
    $resmi_satis_sql = "SELECT * FROM resmi_cari_satislar WHERE musteri_id = ?";
    $resmi_satis_stmt = $pdo->prepare($resmi_satis_sql);
    $resmi_satis_stmt->execute([$musteri_id]);
    $resmi_cari_satislar = $resmi_satis_stmt->fetchAll();

    // Resmi cari satışların toplamını hesapla
    foreach ($resmi_cari_satislar as $satis) {
        $total_resmi_satis += $satis['toplam_tutar'];
    }

    // Seçilen müşteriye ait resmi tahsilatları getirme
    $resmi_tahsilat_sql = "SELECT * FROM resmi_tahsilatlar WHERE musteri_id = ?";
    $resmi_tahsilat_stmt = $pdo->prepare($resmi_tahsilat_sql);
    $resmi_tahsilat_stmt->execute([$musteri_id]);
    $resmi_tahsilatlar = $resmi_tahsilat_stmt->fetchAll();

    // Resmi tahsilatların toplamını hesapla
    foreach ($resmi_tahsilatlar as $tahsilat) {
        $total_resmi_tahsilat += $tahsilat['tutar'];
    }

    // Kalan bakiye
    $kalan_bakiye = $total_resmi_satis - $total_resmi_tahsilat;
}

// Müşteri listesini veritabanından çek
$musteri_sql = "SELECT id, ad_soyad FROM musteriler";
$musteri_stmt = $pdo->query($musteri_sql);
$musteriler = $musteri_stmt->fetchAll();
?>
<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
<div class="layout-wrapper layout-content-navbar">
    
       <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>


    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                     </br>
</br></br>      <h4 class="fw-bold py-3 mb-4">Resmi Cari Ekstre</h4>

                    <!-- Müşteri Seçim Formu -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="musteri_id" class="form-label">Müşteri Seç</label>
                                    <select name="musteri_id" class="form-select" id="musteri_id" required>
                                        <?php foreach ($musteriler as $musteri): ?>
                                            <option value="<?php echo $musteri['id']; ?>" <?php echo ($musteri_id == $musteri['id']) ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($musteri['ad_soyad']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary">Ekstre Göster</button>
                                <?php if ($musteri_id !== null): ?>
                                    <a href="resmi_cari_ekstre_pdf.php?musteri_id=<?php echo $musteri_id; ?>" target="_blank" class="btn btn-danger">PDF Çıktı Al</a>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>

                    <?php if ($musteri_id !== null): ?>
                    <!-- Resmi Cari Satışlar ve Tahsilatlar Tablosu -->
                    <div class="card">
                        <div class="card-body">
                            <h5 class="fw-bold text-center text-success mb-3">RESMİ SATIŞLAR</h5>
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Fatura No</th>
                                        <th>Ürün Adı</th>
                                        <th>Miktar</th>
                                        <th>Fiyat</th>
                                        <th>KDV Oranı</th>
                                        <th>Toplam Tutar</th>
                                        <th>Tarih</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($resmi_cari_satislar as $satis): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($satis['fatura_no']); ?></td>
                                            <td><?php echo htmlspecialchars($satis['urun_adi']); ?></td>
                                            <td><?php echo htmlspecialchars($satis['miktar']); ?></td>
                                            <td><?php echo htmlspecialchars(number_format($satis['fiyat'], 2)); ?></td>
                                            <td><?php echo htmlspecialchars(number_format($satis['kdv_orani'], 2)); ?>%</td>
                                            <td><?php echo htmlspecialchars(number_format($satis['toplam_tutar'], 2)); ?></td>
                                            <td><?php echo htmlspecialchars($satis['tarih']); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-end">Toplam Resmi Satış:</th>
                                        <th><?php echo htmlspecialchars(number_format($total_resmi_satis, 2)); ?> TL</th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>

                            <h5 class="fw-bold text-center text-danger mt-4 mb-3">RESMİ TAHSİLATLAR</h5>
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>İşlem Türü</th>
                                        <th>Tutar</th>
                                        <th>Evrak No</th>
                                        <th>Tarih</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($resmi_tahsilatlar as $tahsilat): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($tahsilat['islem_turu']); ?></td>
                                            <td><?php echo htmlspecialchars(number_format($tahsilat['tutar'], 2)); ?> TL</td>
                                            <td><?php echo htmlspecialchars($tahsilat['evrak_no']); ?></td>
                                            <td><?php echo htmlspecialchars($tahsilat['tarih']); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="1" class="text-end">Toplam Resmi Tahsilat:</th>
                                        <th><?php echo htmlspecialchars(number_format($total_resmi_tahsilat, 2)); ?> TL</th>
                                        <th colspan="2"></th>
                                    </tr>
                                </tfoot>
                            </table>

                            <!-- Bakiye Kısmı -->
                            <div class="mt-4 text-center">
                                <h3 class="fw-bold">Kalan Bakiye: <?php echo htmlspecialchars(number_format($kalan_bakiye, 2)); ?> TL</h3>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
