<?php
ob_start(); // Tamponlama başlatılıyor

error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Resmi cari satış ekleme işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $musteri_id = $_POST['musteri_id'];
    $tarih = $_POST['tarih'];
    $fatura_no = $_POST['fatura_no'];
    $urun_adi = $_POST['urun_adi'];
    $miktar = $_POST['miktar'];
    $fiyat = $_POST['fiyat'];
    $kdv_orani = $_POST['kdv_orani'];
    $aciklama = $_POST['aciklama'];

    // Toplam tutarı hesapla (miktar * fiyat + kdv)
    $kdv_tutari = ($fiyat * $miktar) * ($kdv_orani / 100);
    $toplam_tutar = ($fiyat * $miktar) + $kdv_tutari;
    
    // Oturum açmış kullanıcının ID'sini al
    $created_by = $_SESSION['user_id'];

    // Veritabanına kaydet
    $sql = "INSERT INTO resmi_cari_satislar (musteri_id, tarih, fatura_no, urun_adi, miktar, fiyat, kdv_orani, kdv_tutari, toplam_tutar, aciklama, created_by) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute([$musteri_id, $tarih, $fatura_no, $urun_adi, $miktar, $fiyat, $kdv_orani, $kdv_tutari, $toplam_tutar, $aciklama, $created_by])) {
        $_SESSION['message'] = "Resmi cari satış başarıyla eklendi!";
    } else {
        $_SESSION['error'] = "Resmi cari satış eklenirken bir hata oluştu.";
    }

    header("Location: resmi_cari_satis_ekle.php");
    exit;
}

// Müşteri listesini veritabanından çek
$musteri_sql = "SELECT id, ad_soyad FROM musteriler";
$musteri_stmt = $pdo->query($musteri_sql);
$musteriler = $musteri_stmt->fetchAll();
ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır

?>

<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
<div class="layout-wrapper layout-content-navbar">
      <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>
    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                      </br>
</br></br>   <h4 class="fw-bold py-3 mb-4">Resmi Cari Satış Ekle</h4>

                    <!-- Uyarı Mesajları -->
                    <?php if (isset($_SESSION['message'])): ?>
                        <div class="alert alert-success">
                            <?php echo $_SESSION['message']; ?>
                        </div>
                        <?php unset($_SESSION['message']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger">
                            <?php echo $_SESSION['error']; ?>
                        </div>
                        <?php unset($_SESSION['error']); ?>
                    <?php endif; ?>

                    <!-- Resmi Cari Satış Ekleme Formu -->
                    <div class="card">
                        <div class="card-body">
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="musteri_id" class="form-label">Müşteri Seç</label>
                                    <select name="musteri_id" class="form-select" id="musteri_id" required>
                                        <?php foreach ($musteriler as $musteri): ?>
                                            <option value="<?php echo $musteri['id']; ?>"><?php echo htmlspecialchars($musteri['ad_soyad']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="tarih" class="form-label">Tarih</label>
                                    <input type="date" name="tarih" class="form-control" id="tarih" required>
                                </div>
                                <div class="mb-3">
                                    <label for="fatura_no" class="form-label">Fatura No</label>
                                    <input type="text" name="fatura_no" class="form-control" id="fatura_no" required>
                                </div>
                                <div class="mb-3">
                                    <label for="urun_adi" class="form-label">Ürün Adı</label>
                                    <input type="text" name="urun_adi" class="form-control" id="urun_adi" required>
                                </div>
                                <div class="mb-3">
                                    <label for="miktar" class="form-label">Miktar</label>
                                    <input type="number" name="miktar" class="form-control" id="miktar" required>
                                </div>
                                <div class="mb-3">
                                    <label for="fiyat" class="form-label">Fiyat</label>
                                    <input type="number" name="fiyat" class="form-control" id="fiyat" step="0.01" required>
                                </div>
                                <div class="mb-3">
                                    <label for="kdv_orani" class="form-label">KDV Oranı (%)</label>
                                    <input type="number" name="kdv_orani" class="form-control" id="kdv_orani" step="0.01" required>
                                </div>
                                <div class="mb-3">
                                    <label for="toplam_tutar" class="form-label">Toplam Tutar</label>
                                    <input type="text" name="toplam_tutar" class="form-control" id="toplam_tutar" readonly>
                                </div>
                                <div class="mb-3">
                                    <label for="aciklama" class="form-label">Açıklama</label>
                                    <textarea name="aciklama" class="form-control" id="aciklama"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary">Resmi Cari Satış Ekle</button>
                            </form>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const miktarInput = document.getElementById('miktar');
    const fiyatInput = document.getElementById('fiyat');
    const kdvInput = document.getElementById('kdv_orani');
    const toplamTutarInput = document.getElementById('toplam_tutar');

    function hesaplaToplamTutar() {
        const miktar = parseFloat(miktarInput.value) || 0;
        const fiyat = parseFloat(fiyatInput.value) || 0;
        const kdvOrani = parseFloat(kdvInput.value) || 0;

        const araTutar = miktar * fiyat;
        const kdvTutari = araTutar * (kdvOrani / 100);
        const toplamTutar = araTutar + kdvTutari;

        toplamTutarInput.value = toplamTutar.toFixed(2); // Toplam tutarı iki ondalık basamakla göster
    }

    // Miktar, fiyat veya KDV oranı değiştiğinde toplam tutarı hesapla
    miktarInput.addEventListener('input', hesaplaToplamTutar);
    fiyatInput.addEventListener('input', hesaplaToplamTutar);
    kdvInput.addEventListener('input', hesaplaToplamTutar);
});
</script>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
