<?php
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 
// Kullanıcı ID'sini GET parametresinden al
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

// Kullanıcı bilgilerini veritabanından çek
$stmt = $pdo->prepare("SELECT * FROM profiles WHERE user_id = ?");
$stmt->execute([$user_id]);
$profile = $stmt->fetch();

if (!$profile) {
    echo "Profil bulunamadı.";
    exit;
}



// Gösterilecek maksimum alan sayısı
$maxFieldsToShow = 9;

// Şu ana kadar gösterilen alan sayısı
$fieldsShown = 0;

// Profil alanını göstermek için yardımcı fonksiyon
function displayField($profile, $field, $iconPath, $label, &$fieldsShown, $maxFieldsToShow) {
    if (!empty($profile[$field]) && $fieldsShown < $maxFieldsToShow) {
        echo "<div class='col'>
                <a href='" . htmlspecialchars($profile[$field]) . "' target='_blank'>
                    <img src='ikonlar/$iconPath' alt='$label' class='icon-img-orta'>
                    <p class='icon-label'>$label</p>
                </a>
              </div>";
        $fieldsShown++;
    }
}


?>



<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil Sayfası</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome için ikonlar -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css" rel="stylesheet">
    <!-- Özel stiller -->

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>



    <style>
        .header {
            background-color: #007bff;
            color: #fff;
            padding: 10px;
            height: 33vh; /* Ekranın 3'te biri */
            background-image: url('path_to_background_image.jpg'); /* Arka plan resmi olarak ekleyiniz */
            background-size: cover;
            background-position: center center;
        }
        .header .profile-section {
            padding: 10px 0; /* Profil resmi için üst ve alt padding */
        }
        .header img.profile-img {
            width: 120px; /* Profil resmi genişliği */
            height: 120px; /* Profil resmi yüksekliği */
            border-radius: 50%;
            border: 3px solid white; /* Beyaz çerçeve */
            object-fit: cover;
        }
        .header .name-title {
            text-align: center;
            margin: 0; /* Ad ve ünvan için marj sıfırlama */
        }
        .header .name-title h5 {
            margin-bottom: 2px; /* Adın altındaki boşluk */
        }
        .header .contact-icons img {
            width: 50px; /* İletişim ikonlarının genişliği */
            height: 50px; /* İletişim ikonlarının yüksekliği */
            margin-right: 10px; /* İkonlar arası boşluk */
        }
        .icon-img:last-child {
            margin-right: 0; /* Son ikonun sağında boşluk olmaması için */
        }


.content {
    /* Yükseklik değerini kaldırıyoruz, içerik boyutuna göre esneyecek */
    height: 53vh;
    padding: 20px;
    background-color: #375e7f; /* Arka plan rengi */
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); /* Üstten aşağıya doğru hafif bir gölge */
   

    padding-top: 20px; /* Varsa üst padding'i azaltın */
   


}

.icon-row {
    margin-bottom: 15px; /* İkon satırları arası boşluk */
}

.icon-img-orta {
    width: 90px; /* Resim genişliği */
    height: 90px; /* Resim yüksekliği, orantılı olmalı */
    margin: 0 auto 0px; /* Otomatik yan marjlar ve altta 10px boşluk */
    display: block; /* Blok düzeyinde görüntüleme */
}

.icon-label {
    font-size: 0.9rem; /* Etiket metni boyutu */
    color: #fff; /* Etiket metni rengi */
    margin-bottom: 0px; /* İkon etiketlerinin altındaki boşluk */
}

.icon-description {
    color: #000; /* İkon açıklama metni rengi */
    font-size: 0.9rem; /* İkon açıklama metni boyutu */
    margin-top: 5px; /* Açıklama metni üst boşluğu */
}

/* Responsive görünüm için ekstra küçük cihazlar için ayar */
@media (max-width: 576px) {
    .icon-img-orta {
        width: 75px; /* Küçük cihazlarda resim boyutu */
        height: 75px;
    }
}


.footer {
    background-color: #343a40; /* Arka plan rengi */
    color: #fff;
    height: 14vh;
    padding: 20px 0; /* Üst ve alt padding */
    position: relative; /* Pozisyonu göreli yaparak içindeki elemanları konumlandırabiliriz */
}

.footer-bottom-image {
    width: 100%; /* Resmi footer genişliğine sığdırmak için */
    position: absolute;
    bottom: 0; /* Footer'ın en altına yerleştirmek için */
    left: 0; /* Sol kenardan başlaması için */
}


.social-icons {
    margin-bottom: 20px; /* Logo üstündeki sosyal medya ikonları için alt boşluk */
}

.social-icon {
    width: 40px; /* Sosyal medya ikonlarının genişliği */
    height: auto; /* Yükseklik otomatik olarak ayarlanacak */
    margin: 0 10px; /* Her ikon arasındaki sağ ve sol boşluk */
    display: inline-block; /* İkonları yanyana dizmek için */
}

.footer-logo {
    width: 100px; /* Logonun genişliği */
    position: absolute; /* Pozisyonu mutlak yaparak footer içinde serbestçe konumlandırabiliriz */
    bottom: 0; /* Alttan sıfır uzaklıkta */
    left: 50%; /* Sol kenardan yüzde 50 uzaklıkta */
    transform: translateX(-50%) translateY(50%); /* X ekseninde %50 sola, Y ekseninde %50 aşağı taşıyarak merkezleyelim */
}

.kisa-aciklama {
  color: #ffffff; /* Beyaz renk */

}



    </style>
</head>


<body>
<script>
function acPaylasimMenusu() {
  var menu = document.getElementById("paylasimMenusu");
  if (menu.style.display === "none") {
    menu.style.display = "block";
  } else {
    menu.style.display = "none";
  }
}

</script>

    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <div class="layout-page">
                <div class="content-wrapper">
                    <!-- Header -->
<div class="header" style="background-image: url('uploads/<?php echo htmlspecialchars($profile['header_background']); ?>');">
                        <div class="container">
                            <div class="row">
                               <div class="col-12 col-md-4 d-flex align-items-center justify-content-center profile-section">
    <?php if (!empty($profile['profile_image'])): ?>
        <!-- Kullanıcı profil resmi varsa -->
        <img src="uploads/<?php echo htmlspecialchars($profile['profile_image']); ?>" alt="Profil" class="profile-img">
    <?php else: ?>
        <!-- Varsayılan profil ikonu -->
        <img src="ikonlar/profil.png" alt="Profil" class="profile-img">
    <?php endif; ?>
</div>
                                <div class="col-12 col-md-8">
                                    <div class="name-title">
                                        <h5><?php echo htmlspecialchars($profile['full_name']); ?></h5>
                                        <p> <?php echo htmlspecialchars($profile['title']); ?></p>
                                    </div>
                                 <div class="contact-icons d-flex justify-content-center justify-content-md-start">
    <a href="tel:+<?php echo htmlspecialchars($profile['phone']); ?>">
        <img src="ikonlar/araikonu.png" alt="Telefon" class="icon-img">
    </a>
    <a href="mailto:<?php echo htmlspecialchars($profile['mail']); ?>">
        <img src="ikonlar/mailikonu.png" alt="Email" class="icon-img">
    </a>
 <a href="<?php echo htmlspecialchars($profile['location_link']); ?>" target="_blank">
    <img src="ikonlar/konumikonu.png" alt="Konum" class="icon-img">
</a>
<a href="<?php echo htmlspecialchars($profile['website_url']); ?>" target="_blank">
    <img src="ikonlar/webikonu.png" alt="Website" class="icon-img">
</a>

    

<img src="ikonlar/paylasikonu.png" alt="Paylaş" class="icon-img" onclick="acPaylasimMenusu()">
<div id="paylasimMenusu" style="display:none;">
  <a href="https://www.facebook.com/sharer/sharer.php?u=YourPageURL" target="_blank">Facebook'ta Paylaş</a>
  <a href="https://twitter.com/intent/tweet?url=YourPageURL" target="_blank">Twitter'da Paylaş</a>
  <a href="https://www.linkedin.com/shareArticle?mini=true&url=YourPageURL" target="_blank">LinkedIn'de Paylaş</a>
</div>



</div>

                                </div>
                            </div>
                        </div>
                    </div>







     <div class="container-xxl flex-grow-1 container-p-y content" style="background-image: url('uploads/<?php echo htmlspecialchars($profile['content_background']); ?>'); background-size: cover; background-position: center;">
                    <div class="row">
                        <div class="col-12">
                            <p class="kisa-aciklama"><?php echo htmlspecialchars($profile['about_summary']); ?></p>
                        </div>
                    </div>

                    <div class="row icon-row text-center">
                        <!-- Dinamik olarak profil alanlarını burada göster -->
                        <?php
                        // Profil alanlarını burada göster
                        displayField($profile, 'facebook', 'facebook.png', 'Facebook', $fieldsShown, $maxFieldsToShow);
                        displayField($profile, 'instagram', 'instagram.png', 'Instagram', $fieldsShown, $maxFieldsToShow);
                        displayField($profile, 'twitter', 'x.png', 'Twitter', $fieldsShown, $maxFieldsToShow);
                        displayField($profile, 'whatsapp', 'whatsapp.png', 'whatsapp', $fieldsShown, $maxFieldsToShow);
                        // Diğer profil alanları için benzer çağrıları ekleyin
                        
                        // Eğer gösterilecek özel bir modal ya da link varsa, direkt olarak burada ekleyin
                        // Örneğin, IBAN bilgisi için modal tetikleyici
                        if (!empty($profile['bank_iban']) && $fieldsShown < $maxFieldsToShow) {
                            echo "<div class='col'>
                                    <a href='#' data-toggle='modal' data-target='#bankaBilgileriModal'>
                                        <img src='ikonlar/isbank.png' alt='İş Bankası' class='icon-img-orta'>
                                        <p class='icon-label'>İBAN</p>
                                    </a>
                                  </div>";
                            $fieldsShown++;
                        }
                        ?>
                    </div>
                </div>




<div class="footer text-center">
  <div class="social-icons">
    <?php
    $socialMedia = [
        'youtube' => 'youtube.png',
        'tiktok' => 'tiktok.png',
        'twitter' => 'x.png',
        'facebook' => 'facebook.png',
        'instagram' => 'instagram.png',
        'linkedin' => 'linkedin.png',
        'snapchat' => 'snapchat.png',
        'spotify' => 'spotify.png',
        'threads' => 'threads.png',
        
    ];
    
    $count = 0;
    
    foreach ($socialMedia as $key => $icon) {
        if (!empty($profile[$key]) && $count < 5) {
            echo '<a href="' . htmlspecialchars($profile[$key]) . '" target="_blank">
                    <img src="ikonlar/' . $icon . '" alt="' . ucfirst($key) . '" class="social-icon">
                  </a>';
            $count++;
        }
    }
    ?>
  </div>
</div>





       <img src="ikonlar/alt.png" alt="Footer Resmi" class="footer-bottom-image">

</div>


                    <!-- Diğer içerikler -->
                </div>
            </div>
        </div>
    </div>
    <!-- Bootstrap ve diğer betikler -->
</body>
</html>

