<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Form gönderildiğinde veritabanını güncelle
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // users tablosu için bilgiler
    $username = $_POST['username'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    // Şifre güncellenmişse, hash'le
    if (!empty($password)) {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
        $stmt->execute([$hashed_password, $user_id]);
    }

    // users tablosunu güncelle
    $stmt = $pdo->prepare("UPDATE users SET username = ?, email = ? WHERE id = ?");
    $stmt->execute([$username, $email, $user_id]);

    echo "<p>Bilgiler başarıyla güncellendi.</p>";
}

// Mevcut kullanıcı bilgilerini çek
$stmt = $pdo->prepare("SELECT username, email FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

if (!$user) {
    echo "Kullanıcı bulunamadı.";
    exit;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta viewport="width=device-width, initial-scale=1.0">
    <title>Temel Bilgileri Düzenle</title>
</head>
<body>
    <h2>Temel Bilgileri Düzenle</h2>

    <form action="" method="post">
        <label for="username">Kullanıcı Adı:</label>
        <input type="text" name="username" id="username" value="<?php echo htmlspecialchars($user['username'] ?? ''); ?>">

        <label for="email">E-posta:</label>
        <input type="email" name="email" id="email" value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>">

        <label for="password">Yeni Şifre (değiştirmek istemiyorsanız boş bırakın):</label>
        <input type="password" name="password" id="password">

        <button type="submit">Güncelle</button>
    </form>
</body>
</html>
