<?php
session_start();
require 'db.php';

// Yalnızca yönetici bu sayfaya erişebilir
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

// Kullanıcı bilgilerini getir
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = $_GET['id'];
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$id]);
    $user = $stmt->fetch();

    if (!$user) {
        exit('Kullanıcı bulunamadı.');
    }
} else {
    exit('Geçersiz ID.');
}

// Form gönderildiğinde güncelleme yap
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'] ?? $user['username'];
    $email = $_POST['email'] ?? $user['email'];
    $role = $_POST['role'] ?? $user['role'];
    $password = $_POST['password'];

    // Şifre alanı doldurulmuşsa, şifreyi güncelle
    if (!empty($password)) {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    } else {
        $hashed_password = $user['password'];
    }

    $stmt = $pdo->prepare("UPDATE users SET username = ?, email = ?, role = ?, password = ? WHERE id = ?");
    $stmt->execute([$username, $email, $role, $hashed_password, $id]);

    echo "<p>Kullanıcı başarıyla güncellendi.</p>";
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kullanıcı Düzenle</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <h2>Kullanıcı Düzenle</h2>

    <form action="" method="post">
        <label for="username">Kullanıcı Adı:</label>
        <input type="text" name="username" id="username" value="<?php echo htmlspecialchars($user['username']); ?>" required>

        <label for="email">E-posta:</label>
        <input type="email" name="email" id="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>

        <label for="password">Yeni Şifre (boş bırakılırsa değişmez):</label>
        <input type="password" name="password" id="password">

        <label for="role">Rol:</label>
        <select name="role" id="role">
            <option value="user" <?php echo $user['role'] == 'user' ? 'selected' : ''; ?>>Kullanıcı</option>
            <option value="admin" <?php echo $user['role'] == 'admin' ? 'selected' : ''; ?>>Yönetici</option>
        </select>

        <button type="submit">Güncelle</button>
    </form>

    <a href="admin.php">Geri Dön</a>
</body>
</html>
