<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php';
include 'header.php';

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Düzenlenecek çekin ID'sini al
if (isset($_GET['id'])) {
    $cek_id = $_GET['id'];

    // Çek bilgilerini veritabanından al
    $sql = "SELECT * FROM cekler WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$cek_id]);
    $cek = $stmt->fetch();

    // Çek bilgileri formdan gönderildiyse güncelle
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $cek_adi = $_POST['cek_adi']; // Çek adı ekleme
        $cek_no = $_POST['cek_no'];
        $alinan_tarih = $_POST['alinan_tarih'];
        $tutar = $_POST['tutar'];
        $cirocu = $_POST['cirocu'];
        $verilen_yer = $_POST['verilen_yer'];
        $vade_tarihi = $_POST['vade_tarihi'];
        $banka_bilgisi = $_POST['banka_bilgisi'];

        // Çek bilgilerini güncelleme sorgusu
        $sql = "UPDATE cekler SET cek_adi = ?, cek_no = ?, alinan_tarih = ?, tutar = ?, cirocu = ?, verilen_yer = ?, vade_tarihi = ?, banka_bilgisi = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        if ($stmt->execute([$cek_adi, $cek_no, $alinan_tarih, $tutar, $cirocu, $verilen_yer, $vade_tarihi, $banka_bilgisi, $cek_id])) {
            $_SESSION['message'] = "Çek bilgileri başarıyla güncellendi!";
        } else {
            $_SESSION['error'] = "Çek bilgileri güncellenirken bir hata oluştu.";
        }

        header("Location: cek_listesi.php");
        exit;
    }
} else {
    $_SESSION['error'] = "Geçersiz çek ID'si.";
    header("Location: cek_listesi.php");
    exit;
}
?>

<style>
.mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}
</style>

<div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                </br></br></br>
                <h4 class="mb-4">Çek Düzenle</h4>
                <form action="cek_duzenle.php?id=<?php echo $cek['id']; ?>" method="post" class="border p-4 shadow rounded">
                    <div class="mb-3">
                        <label for="cek_adi" class="form-label">Çek Adı:</label> <!-- Yeni çek adı alanı -->
                        <input type="text" class="form-control" name="cek_adi" id="cek_adi" value="<?php echo htmlspecialchars($cek['cek_adi']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="cek_no" class="form-label">Çek No:</label>
                        <input type="text" class="form-control" name="cek_no" id="cek_no" value="<?php echo htmlspecialchars($cek['cek_no']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="alinan_tarih" class="form-label">Alınan Tarih:</label>
                        <input type="date" class="form-control" name="alinan_tarih" id="alinan_tarih" value="<?php echo htmlspecialchars($cek['alinan_tarih']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="tutar" class="form-label">Tutar:</label>
                        <input type="text" class="form-control" name="tutar" id="tutar" value="<?php echo htmlspecialchars($cek['tutar']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="cirocu" class="form-label">Cirocu:</label>
                        <input type="text" class="form-control" name="cirocu" id="cirocu" value="<?php echo htmlspecialchars($cek['cirocu']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="verilen_yer" class="form-label">Verilen Yer:</label>
                        <input type="text" class="form-control" name="verilen_yer" id="verilen_yer" value="<?php echo htmlspecialchars($cek['verilen_yer']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="vade_tarihi" class="form-label">Vade Tarihi:</label>
                        <input type="date" class="form-control" name="vade_tarihi" id="vade_tarihi" value="<?php echo htmlspecialchars($cek['vade_tarihi']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="banka_bilgisi" class="form-label">Banka Bilgisi:</label>
                        <input type="text" class="form-control" name="banka_bilgisi" id="banka_bilgisi" value="<?php echo htmlspecialchars($cek['banka_bilgisi']); ?>" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
