<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php';
include 'header.php';

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $cek_adi = $_POST['cek_adi']; // Yeni alan
    $cek_no = $_POST['cek_no'];
    $alinan_tarih = $_POST['alinan_tarih'];
    $tutar = $_POST['tutar'];
    $cirocu = $_POST['cirocu'];
    $verilen_yer = $_POST['verilen_yer'];
    $vade_tarihi = $_POST['vade_tarihi'];
    $banka_bilgisi = $_POST['banka_bilgisi'];
    $created_by = $_SESSION['user_id'];

    $sql = "INSERT INTO cekler (cek_adi, cek_no, alinan_tarih, tutar, cirocu, verilen_yer, vade_tarihi, banka_bilgisi, created_by) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);

    if ($stmt->execute([$cek_adi, $cek_no, $alinan_tarih, $tutar, $cirocu, $verilen_yer, $vade_tarihi, $banka_bilgisi, $created_by])) {
        $_SESSION['message'] = "Çek başarıyla kaydedildi!";
    } else {
        $_SESSION['error'] = "Çek kaydedilirken bir hata oluştu.";
    }

    header("Location: cek_listesi.php"); 
    exit;
}

ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır
?>

<style>
.mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}
</style>

<div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                </br></br></br>
                <h4 class="mb-4">Çek Ekle</h4>
                <form action="cek_ekle.php" method="post">
                    <div class="mb-3">
                        <label for="cek_adi" class="form-label">Çek Adı:</label> <!-- Yeni alan -->
                        <input type="text" name="cek_adi" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="cek_no" class="form-label">Çek No:</label>
                        <input type="text" name="cek_no" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="alinan_tarih" class="form-label">Alınan Tarih:</label>
                        <input type="date" name="alinan_tarih" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="tutar" class="form-label">Tutar:</label>
                        <input type="number" name="tutar" class="form-control" step="0.01" required>
                    </div>
                    <div class="mb-3">
                        <label for="cirocu" class="form-label">Cirocu:</label>
                        <input type="text" name="cirocu" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label for="verilen_yer" class="form-label">Verilen Yer:</label>
                        <input type="text" name="verilen_yer" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label for="vade_tarihi" class="form-label">Vade Tarihi:</label>
                        <input type="date" name="vade_tarihi" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label for="banka_bilgisi" class="form-label">Banka Bilgisi:</label>
                        <input type="text" name="banka_bilgisi" class="form-control">
                    </div>
                    <button type="submit" class="btn btn-primary">Ekle</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
