<?php
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Firmalar genel borç durumlarını hesaplama
$firma_borc_durumlari = [];
$total_satis = 0;
$total_odeme = 0;
$total_bakiye = 0;

// Veritabanından firmaları çek
$firma_sql = "SELECT id, firma_adi FROM firmalar";
$firma_stmt = $pdo->query($firma_sql);
$firmalar = $firma_stmt->fetchAll();

foreach ($firmalar as $firma) {
    $firma_id = $firma['id'];

    // Toplam alışları çek
    $alis_sql = "SELECT SUM(toplam_tutar) as total_satis FROM cari_alislar WHERE firma_id = ?";
    $alis_stmt = $pdo->prepare($alis_sql);
    $alis_stmt->execute([$firma_id]);
    $total_satis_row = $alis_stmt->fetch();
    $firma_toplam_satis = $total_satis_row['total_satis'] ?? 0;

    // Toplam ödemeleri çek
    $odeme_sql = "SELECT SUM(tutar) as total_odeme FROM odemeler WHERE firma_id = ?";
    $odeme_stmt = $pdo->prepare($odeme_sql);
    $odeme_stmt->execute([$firma_id]);
    $total_odeme_row = $odeme_stmt->fetch();
    $firma_toplam_odeme = $total_odeme_row['total_odeme'] ?? 0;

    // Bakiye hesaplama
    $firma_bakiye = $firma_toplam_satis - $firma_toplam_odeme;

    // Toplamları güncelle
    $total_satis += $firma_toplam_satis;
    $total_odeme += $firma_toplam_odeme;
    $total_bakiye += $firma_bakiye;

    // Sonuçları diziye ekle
    $firma_borc_durumlari[] = [
        'firma_adi' => $firma['firma_adi'],
        'toplam_satis' => $firma_toplam_satis,
        'toplam_odeme' => $firma_toplam_odeme,
        'bakiye' => $firma_bakiye
    ];
}
?>
<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
<div class="layout-wrapper layout-content-navbar">
    
       <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                        </br>
</br></br>   <h4 class="fw-bold py-3 mb-4">Firma Genel Borç Durumu</h4>

                    <!-- Firma Genel Borç Tablosu -->
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>FİRMA ADI</th>
                                        <th>TOPLAM ALIŞ</th>
                                        <th>TOPLAM ÖDEME</th>
                                        <th>BAKİYE</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($firma_borc_durumlari as $borc_durumu): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($borc_durumu['firma_adi']); ?></td>
                                            <td><?php echo htmlspecialchars(number_format($borc_durumu['toplam_satis'], 2)); ?> TL</td>
                                            <td><?php echo htmlspecialchars(number_format($borc_durumu['toplam_odeme'], 2)); ?> TL</td>
                                            <td><?php echo htmlspecialchars(number_format($borc_durumu['bakiye'], 2)); ?> TL</td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>TOPLAM</th>
                                        <th><?php echo htmlspecialchars(number_format($total_satis, 2)); ?> TL</th>
                                        <th><?php echo htmlspecialchars(number_format($total_odeme, 2)); ?> TL</th>
                                        <th><?php echo htmlspecialchars(number_format($total_bakiye, 2)); ?> TL</th>
                                    </tr>
                                </tfoot>
                            </table>

                            <!-- PDF Çıktı Al Butonu -->
                            <div class="mt-4 text-end">
                                <a href="firma_genel_borc_pdf.php" class="btn btn-danger" target="_blank">PDF Çıktı Al</a>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
