<?php
require 'db.php';
require_once('tcpdf/tcpdf.php');

// Firmalar genel borç durumlarını hesaplama
$firma_borc_durumlari = [];
$total_satis = 0;
$total_odeme = 0;
$total_bakiye = 0;

// Veritabanından firmaları çek
$firma_sql = "SELECT id, firma_adi FROM firmalar";
$firma_stmt = $pdo->query($firma_sql);
$firmalar = $firma_stmt->fetchAll();

foreach ($firmalar as $firma) {
    $firma_id = $firma['id'];

    // Toplam alışları çek
    $alis_sql = "SELECT SUM(toplam_tutar) as total_satis FROM cari_alislar WHERE firma_id = ?";
    $alis_stmt = $pdo->prepare($alis_sql);
    $alis_stmt->execute([$firma_id]);
    $total_satis_row = $alis_stmt->fetch();
    $firma_toplam_satis = $total_satis_row['total_satis'] ?? 0;

    // Toplam ödemeleri çek
    $odeme_sql = "SELECT SUM(tutar) as total_odeme FROM odemeler WHERE firma_id = ?";
    $odeme_stmt = $pdo->prepare($odeme_sql);
    $odeme_stmt->execute([$firma_id]);
    $total_odeme_row = $odeme_stmt->fetch();
    $firma_toplam_odeme = $total_odeme_row['total_odeme'] ?? 0;

    // Bakiye hesaplama
    $firma_bakiye = $firma_toplam_satis - $firma_toplam_odeme;

    // Toplamları güncelle
    $total_satis += $firma_toplam_satis;
    $total_odeme += $firma_toplam_odeme;
    $total_bakiye += $firma_bakiye;

    // Sonuçları diziye ekle
    $firma_borc_durumlari[] = [
        'firma_adi' => $firma['firma_adi'],
        'toplam_satis' => $firma_toplam_satis,
        'toplam_odeme' => $firma_toplam_odeme,
        'bakiye' => $firma_bakiye
    ];
}

// TCPDF ayarları
$pdf = new TCPDF();
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Firma Genel Borç Durumu');
$pdf->SetTitle('Firma Genel Borç Durumu');
$pdf->SetHeaderData('', 0, 'Firma Genel Borç Durumu', '');
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->AddPage();

// Türkçe karakterler için DejaVuSans fontunu yükle
$pdf->SetFont('dejavusans', '', 12);

// İçerik ekle
$html = '<h1>Firma Genel Borç Durumu</h1>';

// Firma Borç Tablosu
$html .= '<table border="1" cellpadding="5">';
$html .= '<thead>
            <tr>
                <th>FİRMA ADI</th>
                <th>TOPLAM ALIŞ</th>
                <th>TOPLAM ÖDEME</th>
                <th>BAKİYE</th>
            </tr>
          </thead>
          <tbody>';

foreach ($firma_borc_durumlari as $borc_durumu) {
    $html .= '<tr>
                <td>' . htmlspecialchars($borc_durumu['firma_adi']) . '</td>
                <td>' . htmlspecialchars(number_format($borc_durumu['toplam_satis'], 2)) . ' TL</td>
                <td>' . htmlspecialchars(number_format($borc_durumu['toplam_odeme'], 2)) . ' TL</td>
                <td>' . htmlspecialchars(number_format($borc_durumu['bakiye'], 2)) . ' TL</td>
              </tr>';
}

$html .= '</tbody>
          <tfoot>
            <tr>
                <th>TOPLAM</th>
                <th>' . htmlspecialchars(number_format($total_satis, 2)) . ' TL</th>
                <th>' . htmlspecialchars(number_format($total_odeme, 2)) . ' TL</th>
                <th>' . htmlspecialchars(number_format($total_bakiye, 2)) . ' TL</th>
            </tr>
          </tfoot>';
$html .= '</table>';

$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output('firma_genel_borc.pdf', 'I');
