<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}


if (isset($_SESSION['message'])): ?>
    <div class="alert alert-success">
        <?php echo $_SESSION['message']; ?>
    </div>
    <?php unset($_SESSION['message']); // Mesajı görüntüledikten sonra temizle
endif; ?>

<?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger">
        <?php echo $_SESSION['error']; ?>
    </div>
    <?php unset($_SESSION['error']); // Hata mesajını görüntüledikten sonra temizle
endif; 


// Müşteri silme işlemi
// Müşteri silme işlemi
if (isset($_GET['delete_id'])) {
    $delete_id = $_GET['delete_id'];
    $delete_sql = "DELETE FROM musteriler WHERE id = ?";
    $delete_stmt = $pdo->prepare($delete_sql);

    if ($delete_stmt->execute([$delete_id])) {
        $_SESSION['message'] = "Müşteri başarıyla silindi!";
    } else {
        $_SESSION['error'] = "Müşteri silinirken bir hata oluştu.";
    }

    // Yönlendirme yapmadan önce sayfada hiçbir çıktı olmadığından emin olun
    header("Location: musteri_listesi.php");
    exit; // Yönlendirme sonrası çıkış yaparak scriptin çalışmasını durdurun
}




if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_id'])) {
    $update_id = $_POST['update_id'];
    $ad_soyad = $_POST['ad_soyad'];
    $telefon = $_POST['telefon'];
    $adres = $_POST['adres'];

    $update_sql = "UPDATE musteriler SET ad_soyad = ?, telefon = ?, adres = ? WHERE id = ?";
    $update_stmt = $pdo->prepare($update_sql);

    if ($update_stmt->execute([$ad_soyad, $telefon, $adres, $update_id])) {
        $message = "Müşteri bilgileri başarıyla güncellendi!";
    } else {
        $message = "Müşteri bilgileri güncellenirken bir hata oluştu: " . $update_stmt->errorInfo()[2];
    }
}




// Mevcut müşteri listesini veritabanından çek
$sql = "SELECT * FROM musteriler";
$stmt = $pdo->query($sql);
$musteriler = $stmt->fetchAll();


ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır

?>
<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
<div class="layout-wrapper layout-content-navbar">
      <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

    <div class="layout-container">
        <!-- Başlangıç: Yan Menü -->
        <!-- Yan menü kodları sidebar.php dosyasından geliyor -->
        <!-- Bitiş: Yan Menü -->

        <div class="layout-page">
            <!-- Başlangıç: Üst Navigasyon -->
            <!-- Üst navigasyon kodları header.php dosyasından geliyor -->
            <!-- Bitiş: Üst Navigasyon -->

            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
               </br>
</br></br>            <h4 class="fw-bold py-3 mb-4">Müşteri Listesi</h4>

                    <!-- Uyarı Mesajları -->
                    <?php if (isset($_SESSION['message'])): ?>
                        <div class="alert alert-success">
                            <?php echo htmlspecialchars($_SESSION['message']); ?>
                        </div>
                        <?php unset($_SESSION['message']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger">
                            <?php echo htmlspecialchars($_SESSION['error']); ?>
                        </div>
                        <?php unset($_SESSION['error']); ?>
                    <?php endif; ?>

                    <!-- Müşteri Listesi ve İşlemler -->
                    <div class="card">
                        <div class="card-body">
                            <?php if (empty($musteriler)): ?>
                                <div class="alert alert-warning">Hiç müşteri bulunmamaktadır.</div>
                            <?php else: ?>
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Ad Soyad</th>
                                        <th>Telefon</th>
                                        <th>Adres</th>
                                        <th>İşlemler</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($musteriler as $musteri): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($musteri['id']); ?></td>
                                            <td><?php echo htmlspecialchars($musteri['ad_soyad']); ?></td>
                                            <td><?php echo htmlspecialchars($musteri['telefon']); ?></td>
                                            <td><?php echo htmlspecialchars($musteri['adres']); ?></td>
                                            <td>
                                                <!-- Müşteri bilgilerini güncelle -->
                                                <button type="button" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#updateModal<?php echo $musteri['id']; ?>">
                                                    Güncelle
                                                </button>

                                                <!-- Müşteri silme işlemi -->
                                                <a href="musteri_listesi.php?delete_id=<?php echo $musteri['id']; ?>" class="btn btn-danger" onclick="return confirm('Bu müşteriyi gerçekten silmek istiyor musunuz?')">Sil</a>
                                            </td>
                                        </tr>

                                        <!-- Güncelleme Modalı -->
                                        <div class="modal fade" id="updateModal<?php echo $musteri['id']; ?>" tabindex="-1" aria-labelledby="updateModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="updateModalLabel">Müşteri Bilgilerini Güncelle</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <form method="POST">
                                                            <input type="hidden" name="update_id" value="<?php echo $musteri['id']; ?>">
                                                            <div class="mb-3">
                                                                <label for="ad_soyad" class="form-label">Ad Soyad</label>
                                                                <input type="text" name="ad_soyad" class="form-control" id="ad_soyad" value="<?php echo htmlspecialchars($musteri['ad_soyad']); ?>" required>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="telefon" class="form-label">Telefon</label>
                                                                <input type="text" name="telefon" class="form-control" id="telefon" value="<?php echo htmlspecialchars($musteri['telefon']); ?>">
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="adres" class="form-label">Adres</label>
                                                                <textarea name="adres" class="form-control" id="adres"><?php echo htmlspecialchars($musteri['adres']); ?></textarea>
                                                            </div>
                                                            <button type="submit" class="btn btn-primary">Güncelle</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
