<?php
ob_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// URL'den ID'yi al
$id = $_GET['id'] ?? null;

if (!$id) {
    echo "Geçersiz ID.";
    exit;
}

// Ödeme kaydını getir
$sql = "SELECT * FROM odemeler WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$id]);
$odeme = $stmt->fetch();

if (!$odeme) {
    echo "Kayıt bulunamadı.";
    exit;
}

// Form gönderildiyse, güncelle
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $firma_id = $_POST['firma_id'];
    $tarih = $_POST['tarih'];
    $tutar = $_POST['tutar'];
    $islem_turu = $_POST['islem_turu'];
    $aciklama = $_POST['aciklama'];

    $sql = "UPDATE odemeler SET firma_id = ?, tarih = ?, tutar = ?, islem_turu = ?, aciklama = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);

    if ($stmt->execute([$firma_id, $tarih, $tutar, $islem_turu, $aciklama, $id])) {
        $_SESSION['message'] = "Ödeme kaydı başarıyla güncellendi!";
        header("Location: odeme_listesi.php");
        exit;
    } else {
        echo "Güncelleme sırasında bir hata oluştu.";
    }
}
?>
  <style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
   <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                </br>
</br></br>   <h4 class="mb-4">Ödeme Düzenle</h4>
                <form action="" method="post" class="border p-4 shadow rounded">
                    <div class="mb-3">
                        <label for="firma_id" class="form-label">Firma ID:</label>
                        <input type="text" class="form-control" name="firma_id" id="firma_id" value="<?php echo htmlspecialchars($odeme['firma_id']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="tarih" class="form-label">Tarih:</label>
                        <input type="date" class="form-control" name="tarih" id="tarih" value="<?php echo htmlspecialchars($odeme['tarih']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="tutar" class="form-label">Tutar:</label>
                        <input type="text" class="form-control" name="tutar" id="tutar" value="<?php echo htmlspecialchars($odeme['tutar']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="islem_turu" class="form-label">İşlem Türü:</label>
                        <input type="text" class="form-control" name="islem_turu" id="islem_turu" value="<?php echo htmlspecialchars($odeme['islem_turu']); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="aciklama" class="form-label">Açıklama:</label>
                        <textarea class="form-control" name="aciklama" id="aciklama"><?php echo htmlspecialchars($odeme['aciklama']); ?></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
