<?php
require_once('tcpdf/tcpdf.php');
require 'db.php';

if (!isset($_GET['musteri_id'])) {
    die("Müşteri seçilmedi.");
}

$musteri_id = $_GET['musteri_id'];

// Müşteri bilgilerini veritabanından çekme
$musteri_sql = "SELECT ad_soyad FROM musteriler WHERE id = ?";
$musteri_stmt = $pdo->prepare($musteri_sql);
$musteri_stmt->execute([$musteri_id]);
$musteri = $musteri_stmt->fetch();

// Resmi cari satışları ve tahsilatları veritabanından çekme
$resmi_satis_sql = "SELECT * FROM resmi_cari_satislar WHERE musteri_id = ?";
$resmi_satis_stmt = $pdo->prepare($resmi_satis_sql);
$resmi_satis_stmt->execute([$musteri_id]);
$resmi_cari_satislar = $resmi_satis_stmt->fetchAll();

$resmi_tahsilat_sql = "SELECT * FROM resmi_tahsilatlar WHERE musteri_id = ?";
$resmi_tahsilat_stmt = $pdo->prepare($resmi_tahsilat_sql);
$resmi_tahsilat_stmt->execute([$musteri_id]);
$resmi_tahsilatlar = $resmi_tahsilat_stmt->fetchAll();

// Toplamları hesaplama
$total_resmi_satis = 0;
foreach ($resmi_cari_satislar as $satis) {
    $total_resmi_satis += $satis['toplam_tutar'];
}

$total_resmi_tahsilat = 0;
foreach ($resmi_tahsilatlar as $tahsilat) {
    $total_resmi_tahsilat += $tahsilat['tutar'];
}

$kalan_bakiye = $total_resmi_satis - $total_resmi_tahsilat;

// TCPDF nesnesini oluştur
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// PDF meta verilerini ayarlama
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Net Araç Takip Sistemleri');
$pdf->SetTitle('Resmi Cari Ekstre');
$pdf->SetSubject('Resmi Cari Ekstre');
$pdf->SetKeywords('TCPDF, PDF, Resmi Cari Ekstre, Rapor');

// Üstbilgi ve altbilgi ayarları
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Yazı tipini ayarlama
$pdf->SetFont('dejavusans', '', 10);

// Yeni sayfa ekleme
$pdf->AddPage();

// PDF içeriğini oluşturma
$html = '<h1>Resmi Cari Ekstre - ' . htmlspecialchars($musteri['ad_soyad']) . '</h1>';

// Satışlar tablosu
$html .= '<h2>Resmi Satışlar</h2>';
$html .= '<table border="1" cellpadding="4">
            <thead>
                <tr>
                    <th>Fatura No</th>
                    <th>Ürün Adı</th>
                    <th>Miktar</th>
                    <th>Fiyat</th>
                    <th>KDV Oranı</th>
                    <th>Toplam Tutar</th>
                    <th>Tarih</th>
                </tr>
            </thead>
            <tbody>';

foreach ($resmi_cari_satislar as $satis) {
    $html .= '<tr>
                <td>' . htmlspecialchars($satis['fatura_no']) . '</td>
                <td>' . htmlspecialchars($satis['urun_adi']) . '</td>
                <td>' . htmlspecialchars($satis['miktar']) . '</td>
                <td>' . number_format($satis['fiyat'], 2) . '</td>
                <td>' . number_format($satis['kdv_orani'], 2) . '%</td>
                <td>' . number_format($satis['toplam_tutar'], 2) . ' TL</td>
                <td>' . htmlspecialchars($satis['tarih']) . '</td>
              </tr>';
}

$html .= '</tbody></table>';

// Tahsilatlar tablosu
$html .= '<h2>Resmi Tahsilatlar</h2>';
$html .= '<table border="1" cellpadding="4">
            <thead>
                <tr>
                    <th>İşlem Türü</th>
                    <th>Tutar</th>
                    <th>Evrak No</th>
                    <th>Tarih</th>
                </tr>
            </thead>
            <tbody>';

foreach ($resmi_tahsilatlar as $tahsilat) {
    $html .= '<tr>
                <td>' . htmlspecialchars($tahsilat['islem_turu']) . '</td>
                <td>' . number_format($tahsilat['tutar'], 2) . ' TL</td>
                <td>' . htmlspecialchars($tahsilat['evrak_no']) . '</td>
                <td>' . htmlspecialchars($tahsilat['tarih']) . '</td>
              </tr>';
}

$html .= '</tbody></table>';

// Kalan bakiye
$html .= '<h3>Kalan Bakiye: ' . number_format($kalan_bakiye, 2) . ' TL</h3>';

// HTML içeriği PDF'e ekleme
$pdf->writeHTML($html, true, false, true, false, '');

// PDF'i tarayıcıda gösterme
$pdf->Output('resmi_cari_ekstre.pdf', 'I');
?>
