<?php
ob_start(); // Tamponlama başlatılıyor

session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Resmi tahsilat ekleme işlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $musteri_id = $_POST['musteri_id'];
    $tarih = $_POST['tarih'];
    $tutar = $_POST['tutar'];
    $islem_turu = $_POST['islem_turu'];
    $evrak_no = $_POST['evrak_no'];
    $aciklama = $_POST['aciklama'];

    // Oturum açmış kullanıcının ID'sini al
    $created_by = $_SESSION['user_id'];

    $sql = "INSERT INTO resmi_tahsilatlar (musteri_id, tarih, tutar, islem_turu, evrak_no, aciklama, created_by) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute([$musteri_id, $tarih, $tutar, $islem_turu, $evrak_no, $aciklama, $created_by])) {
        $_SESSION['message'] = "Resmi tahsilat başarıyla eklendi!";
    } else {
        $errorInfo = $stmt->errorInfo();
        $_SESSION['error'] = "Resmi tahsilat eklenirken bir hata oluştu: " . $errorInfo[2];
    }

    header("Location: resmi_tahsilat_ekle.php");
    exit;
}

// Müşteri listesini veritabanından çek
$musteri_sql = "SELECT id, ad_soyad FROM musteriler";
$musteri_stmt = $pdo->query($musteri_sql);
$musteriler = $musteri_stmt->fetchAll();
ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır

?>

<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>

<div class="layout-wrapper layout-content-navbar">
    
       <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>


    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                     </br>
</br></br>    <h4 class="fw-bold py-3 mb-4">Resmi Tahsilat Ekle</h4>

                    <!-- Uyarı Mesajları -->
                    <?php if (isset($_SESSION['message'])): ?>
                        <div class="alert alert-success">
                            <?php echo $_SESSION['message']; ?>
                        </div>
                        <?php unset($_SESSION['message']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger">
                            <?php echo $_SESSION['error']; ?>
                        </div>
                        <?php unset($_SESSION['error']); ?>
                    <?php endif; ?>

                    <!-- Resmi Tahsilat Ekleme Formu -->
                    <div class="card">
                        <div class="card-body">
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="musteri_id" class="form-label">Müşteri Seç</label>
                                    <select name="musteri_id" class="form-select" id="musteri_id" required>
                                        <?php foreach ($musteriler as $musteri): ?>
                                            <option value="<?php echo $musteri['id']; ?>"><?php echo htmlspecialchars($musteri['ad_soyad']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="tarih" class="form-label">Tarih</label>
                                    <input type="date" name="tarih" class="form-control" id="tarih" required>
                                </div>
                                <div class="mb-3">
                                    <label for="tutar" class="form-label">Tutar</label>
                                    <input type="number" name="tutar" class="form-control" id="tutar" step="0.01" required>
                                </div>
                                <div class="mb-3">
                                    <label for="islem_turu" class="form-label">İşlem Türü</label>
                                    <select name="islem_turu" class="form-select" id="islem_turu" required>
                                        <option value="Nakit">Nakit</option>
                                        <option value="Havale">Havale</option>
                                        <option value="Çek">Çek</option>
                                        <option value="Kredi Kartı">Kredi Kartı</option>
                                        <option value="Senet">Senet</option>
                                        <option value="İade">İade</option> <!-- Yeni seçenek eklendi -->
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="evrak_no" class="form-label">Evrak No</label>
                                    <input type="text" name="evrak_no" class="form-control" id="evrak_no">
                                </div>
                                <div class="mb-3">
                                    <label for="aciklama" class="form-label">Açıklama</label>
                                    <textarea name="aciklama" class="form-control" id="aciklama"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary">Resmi Tahsilat Ekle</button>
                            </form>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
