<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Silinecek tahsilatın ID'sini al
$id = $_GET['id'] ?? null;
if (!$id) {
    $_SESSION['error'] = "Geçersiz tahsilat ID'si.";
    header("Location: resmi_tahsilat_listesi.php");
    exit;
}

// Tahsilat kaydını veritabanından sil
$sql = "DELETE FROM resmi_tahsilatlar WHERE id = ?";
$stmt = $pdo->prepare($sql);
if ($stmt->execute([$id])) {
    $_SESSION['message'] = "Tahsilat başarıyla silindi!";
} else {
    $_SESSION['error'] = "Tahsilat silinirken bir hata oluştu.";
}

// Kullanıcıyı liste sayfasına yönlendir
header("Location: resmi_tahsilat_listesi.php");
exit;
?>
