<?php
session_start();
require 'db.php';

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id'])) {
    header("Location: tahsilat_listesi.php");
    exit;
}

$id = $_GET['id'];

try {
    // Tahsilat kaydını sil
    $sql = "DELETE FROM tahsilatlar WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute([$id])) {
        $_SESSION['message'] = "Tahsilat başarıyla silindi!";
    } else {
        $_SESSION['error'] = "Tahsilat silinirken bir hata oluştu.";
    }
} catch (PDOException $e) {
    $_SESSION['error'] = "Veritabanı hatası: " . $e->getMessage();
}

header("Location: tahsilat_listesi.php");
exit;
?>
