<?php
require 'db.php';

// Kullanıcı ID'sini GET parametresinden al
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

// Kullanıcı bilgilerini veritabanından çek
$stmt = $pdo->prepare("SELECT * FROM profiles WHERE user_id = ?");
$stmt->execute([$user_id]);
$profile = $stmt->fetch();

if (!$profile) {
    echo "Profil bulunamadı.";
    exit;
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kullanıcı Profili</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <h1><?php echo htmlspecialchars($profile['full_name']); ?></h1>
    <p><strong>Hakkında: </strong><?php echo htmlspecialchars($profile['about']); ?></p>
    <p><strong>Web Sitesi: </strong><a href="<?php echo htmlspecialchars($profile['website_url']); ?>"><?php echo htmlspecialchars($profile['website_url']); ?></a></p>
    <p><strong>Ürünler Linki: </strong><a href="<?php echo htmlspecialchars($profile['products_link']); ?>"><?php echo htmlspecialchars($profile['products_link']); ?></a></p>
    <p><strong>İletişim Bilgileri: </strong><?php echo htmlspecialchars($profile['contact_info']); ?></p>
    <p><strong>Konum Linki: </strong><a href="<?php echo htmlspecialchars($profile['location_link']); ?>"><?php echo htmlspecialchars($profile['location_link']); ?></a></p>

    <!-- Profil ve Kapak Resimleri -->
    <div>
        <img src="<?php echo htmlspecialchars($profile['profile_image']); ?>" alt="Profil Resmi" style="width: 100px; height: 100px;">
        <img src="<?php echo htmlspecialchars($profile['cover_image']); ?>" alt="Kapak Resmi" style="width: 300px; height: 100px;">
    </div>
</body>
</html>
